<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Neue Zone');
requireLogin();
requireRole(['Administrator']);
showSessionAlert();
initializeDatabaseConnection();

if (isset($_POST['addZone'])) {

    if ($_POST['zoneRestricted'] == "Ja") {
        $zoneRestricted = '1';
    } else {
        $zoneRestricted = NULL;
    }

    if ($_POST['zoneAlarmAuthorisation'] == "Ja") {
        $zoneAlarmAuthorisation = '1';
    } else {
        $zoneAlarmAuthorisation = NULL;
    }

    if (!$_POST['zoneOnExit']) {
        $zoneOnExit = NULL;
    } else {
        $zoneOnExit = $_POST['zoneOnExit'];
    }

    $stmt = $pdo->prepare("INSERT INTO Zones 
            (ZoneName, ZoneColor, ZoneOnExit, Restricted, AlarmAuthorisation)
            VALUES (:ZoneName, :ZoneColor, :ZoneOnExit, :ZoneRestricted, :ZoneAlarmAuthorisation)");

    $stmt->bindParam(':ZoneName', $_POST['zoneName']);
    $stmt->bindParam(':ZoneColor', $_POST['zoneColor']);
    $stmt->bindParam(':ZoneOnExit', $zoneOnExit);
    $stmt->bindParam(':ZoneRestricted', $zoneRestricted);
    $stmt->bindParam(':ZoneAlarmAuthorisation', $zoneAlarmAuthorisation);

    $stmt->execute();

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Zonen', 'Neue Zone "' . $_POST['zoneName'] . '" erstellt');

    // Erstellt einen Session-Alert 
    createSessionAlert("", "Zone " . $_POST['zoneName'] . " erfolgreich erstellt", "success", "false", "2000");

    // Weiterleitung zur Übersicht
    header("Location: /administration/zones");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="addZone" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0">Neu</h4>
            <span class="text-secondary">Zonen</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="addZone">
                <i class="btn-icon-prepend mdi mdi-plus"></i>
                Hinzufügen
            </button>

            <a href="/administration/zones" class="btn btn-secondary btn-icon mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>
        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Einstellungen
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="zoneName" class="form-label">Name</label>
                        <input id="zoneName" name="zoneName" class="form-control" type="text" autofocus>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Eingeschränkt</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneRestricted"
                            data-width="100%">
                            <option value="Nein" selected>Nein</option>
                            <option value="Ja">Ja</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ausgangszone</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneOnExit"
                            data-width="100%">
                            <option value="" selected>Keine Auswahl</option>
                            <?php

                            // Datenbankabfrage
                            $sql = "SELECT * FROM Zones";
                            $stmt = $pdo->query($sql);
                            $Zones = $stmt->fetchAll();

                            if ($Zones) {
                                foreach ($Zones as $Zone) {
                                    echo '<option value="' . $Zone['ZoneID'] . '">' . $Zone['ZoneName'] . '</option>';
                                }
                            }

                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="colorCode" class="form-label">Farbe</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="colorCode" name="zoneColor" value="#004971"
                                readonly>
                            <span class="input-group-text bg-transparent">
                                <div id="pickr_addZone"></div>
                            </span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Alarm-Berechtigung</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneAlarmAuthorisation"
                            data-width="100%">
                            <option value="Nein" selected>Nein</option>
                            <option value="Ja">Ja</option>
                        </select>
                    </div>

                </div>
            </div>
        </div>


    </div>

</form>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>